/*
 * Decompiled with CFR 0.152.
 */
package dan200.computercraft.shared.turtle.upgrades;

import dan200.computercraft.api.turtle.ITurtleAccess;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1263;
import net.minecraft.class_1799;
import net.minecraft.class_1860;
import net.minecraft.class_1937;
import net.minecraft.class_2371;
import net.minecraft.class_3218;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import net.minecraft.class_9694;
import net.minecraft.class_9695;
import org.jspecify.annotations.Nullable;

public final class TurtleInventoryCrafting {
    public static final int WIDTH = 3;
    public static final int HEIGHT = 3;

    private TurtleInventoryCrafting() {
    }

    private static @Nullable FoundRecipe tryCrafting(class_1937 level, final class_1263 inventory, final int xStart, final int yStart) {
        for (int x = 0; x < 4; ++x) {
            for (int y = 0; y < 4; ++y) {
                if (x >= xStart && x < xStart + 3 && y >= yStart && y < yStart + 3 || inventory.method_5438(x + y * 4).method_7960()) continue;
                return null;
            }
        }
        AbstractList<class_1799> items = new AbstractList<class_1799>(){

            @Override
            public class_1799 get(int index) {
                int x = xStart + index % 3;
                int y = yStart + index / 3;
                return x >= 0 && x < 4 && y >= 0 && y < 4 ? inventory.method_5438(x + y * 4) : class_1799.field_8037;
            }

            @Override
            public int size() {
                return 9;
            }
        };
        class_9694 input = class_9694.method_59986((int)3, (int)3, (List)items);
        class_8786 recipe = level.method_8433().method_8132(class_3956.field_17545, (class_9695)input, level).orElse(null);
        return recipe == null ? null : new FoundRecipe((class_1860<class_9694>)recipe.comp_1933(), (List<class_1799>)items, xStart, yStart);
    }

    public static @Nullable List<class_1799> craft(ITurtleAccess turtle, int maxCount) {
        class_1799 result;
        class_9694.class_9765 offsetInput;
        class_9694 input;
        class_1937 level = turtle.getLevel();
        if (level.field_9236 || !(level instanceof class_3218)) {
            return null;
        }
        class_1263 inventory = turtle.getInventory();
        FoundRecipe candidate = TurtleInventoryCrafting.tryCrafting(level, inventory, 0, 0);
        if (candidate == null) {
            candidate = TurtleInventoryCrafting.tryCrafting(level, inventory, 0, 1);
        }
        if (candidate == null) {
            candidate = TurtleInventoryCrafting.tryCrafting(level, inventory, 1, 0);
        }
        if (candidate == null) {
            candidate = TurtleInventoryCrafting.tryCrafting(level, inventory, 1, 1);
        }
        if (candidate == null) {
            return null;
        }
        if (maxCount == 0) {
            return List.of();
        }
        class_1860<class_9694> recipe = candidate.recipe();
        List<class_1799> items = candidate.items();
        ArrayList<class_1799> results = new ArrayList<class_1799>();
        for (int i = 0; i < maxCount && recipe.method_8115((class_9695)(input = (offsetInput = class_9694.method_60505((int)3, (int)3, items)).comp_2795()), level) && !(result = recipe.method_8116((class_9695)input, (class_7225.class_7874)level.method_30349())).method_7960(); ++i) {
            results.add(result);
            result.method_54466(level);
            int xStart = candidate.xStart() + offsetInput.comp_2796();
            int yStart = candidate.yStart() + offsetInput.comp_2797();
            class_2371 remainders = recipe.method_8111((class_9695)input);
            for (int y = 0; y < input.method_59992(); ++y) {
                for (int x = 0; x < input.method_59991(); ++x) {
                    int slot = xStart + x + (y + yStart) * 4;
                    class_1799 existing = inventory.method_5438(slot);
                    class_1799 remainder = (class_1799)remainders.get(x + y * input.method_59991());
                    if (!existing.method_7960()) {
                        inventory.method_5434(slot, 1);
                        existing = inventory.method_5438(slot);
                    }
                    if (remainder.method_7960()) continue;
                    if (existing.method_7960()) {
                        inventory.method_5447(slot, remainder);
                        continue;
                    }
                    if (class_1799.method_31577((class_1799)existing, (class_1799)remainder)) {
                        existing.method_7933(remainder.method_7947());
                        continue;
                    }
                    results.add(remainder);
                }
            }
        }
        return Collections.unmodifiableList(results);
    }

    private record FoundRecipe(class_1860<class_9694> recipe, List<class_1799> items, int xStart, int yStart) {
    }
}

